<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;
    protected $fillable = array('client_id', 'family_id', 'total_price', 'tax', 'net', 'status', 'delivery_type', 'note');

    public function carts()
    {
        return $this->hasMany('App\Models\Cart', 'order_id');
    }

    public function products()
    {
        return $this->belongsToMany('App\Models\Product', 'product_id')->withPivot(['note','price','quantity']);
    }

    public function additions()
    {
        return $this->belongsToMany('App\Models\Addition', 'addition_id')->withPivot(['price','product_id']);
    }

    public function client()
    {
        return $this->belongsTo('App\User', 'client_id');
    }

    public function family()
    {
        return $this->belongsTo('App\User', 'family_id');
    }

    public function notifications()
    {
        return $this->hasMany('App\Models\Notification', 'order_id');
    }

    public function offers()
    {
        return $this->hasMany('App\Models\Offer', 'order_id');
    }

    public function histories()
    {
        return $this->hasMany('App\Models\History');
    }

}